
  /*
   *  Object %name    : %
   *  State           :  %state%
   *  Creation date   :  Mon Feb 07 09:42:53 2008
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief A brief description of this module
   *
   *  \version MW_ATP_UTIL_funcs.c#1:csrc:1
   *  \author NogaD
   *  \remarks Copyright (C) 2008 by Discretix Technologies Ltd.
   *           All Rights reserved
   */

/* disabling pc lint warning regarding to constant condition :
   'Constant value Boolean' */
/*lint --e{506} */
/*lint --e(553) */
/*lint --e(713) */
/************* Include Files **************************************/
#include "MW_ATP_defines.h"
#include "MW_ATP_UTIL_funcs.h"

#include "DX_VOS_BaseTypes.h"
#include "DX_VOS_File.h"
#include "DX_VOS_Stdio.h"
/* extern exit decleration from <stdlib.h> */
extern void exit(int status);

/************************ Defines **********************************/
/************************ Enums ************************************/
/************************ Typedefs *********************************/
/************************ Global Data ******************************/
/*************** Private function prototype ************************/
static void MW_ATP_UTIL_usage(char *pname);

/************************ Public Functions *************************/
/***************************
 * Function Name:
 *  ATP_LOG_TST_PRINT
 *
 * Inputs:
 *  DxUint8_t level - the printing level if it is below the ATP_LOG_TST_MAX_LEVEL_ENABLED
 *                    flag setting it will not be printed.
 *  const char format,... - the printf format.
 *
 * Outputs:
 *   None
 *
 * Description:
 * The following function handles the printings logging of the testing suite .
 *        This function should be called by using the ATP_LOG_TST_PLOT macro
 *
 **************************/
#if ATP_LOG_TST_MAX_LEVEL_ENABLED

int ATP_LOG_TST( DxUint8_t level , const DxChar *format,... )
{
  /* LOCAL DECLERATIONS */
  DX_VA_LIST ap;
  DxVosFile TST_log_ptr = DX_NULL;

  /* FUNCTION LOGIC */
  if (TST_log_fname_ptr != DX_NULL)
  {
      if ( (DX_VOS_FOpen(&TST_log_ptr, TST_log_fname_ptr ,"r+") != DX_SUCCESS )
           ||
           (TST_log_ptr == DX_NULL) )
      {
          DX_VOS_Printf("CANT OPEN LOG FILE \n");
          return TST_FAIL;
      }
	  else
		  DX_VOS_FSeekEx(TST_log_ptr,0,DX_SEEK_END);
	  

  }
  //else ->
      //write the output to stdout!
  /* if the printing level is enabled then print it */
  if( level < ATP_LOG_TST_MAX_LEVEL_ENABLED )
  {
      DX_VA_START(ap, format);
      if (TST_log_fname_ptr != DX_NULL)
      {
          DX_VOS_VFPrintf( TST_log_ptr,format , ap );
      }
      
      DX_VOS_VPrintf(format , ap);
      
      DX_VA_END(ap);
  }
  if (TST_log_fname_ptr != DX_NULL)
      DX_VOS_FClose(TST_log_ptr);
  return TST_PASS;

}/* END OF ATP_LOG_TST */

#endif


/***************************
 * Function Name:
 *  ATP_LOG_DEV_DisplayBuffer
 *
 * Inputs:
 *  DxUint8_t  level - the printing level if it is below the CRYS_LOG_TST_MAX_LEVEL_ENABLED
 *                    flag setting it will not be printed.
 *  char     Label - a label string.
 *  DxUint8_t  Buffer - the buffer to be printed.
 *  uint32_  Size  - the buffer size in bytes.
 *
 * Outputs:
 *   None
 *
 * Description:
 *  The following function prints a buffer.
 *
 **************************/
#if ATP_LOG_TST_MAX_LEVEL_ENABLED
void ATP_LOG_TST_DisplayBuffer(DxUint8_t level , char  *Label,DxUint8_t *Buffer,DxUint32_t Size )

{
  /* LOCAL DECLERATIONS */

  /* loop variable */
  DxUint32_t  i;

  /* FUNCTION LOGIC */

  /* print the label */
  ATP_LOG_TST_PRINT(( level , "\n%s BufferSize(Byte) %ld // BufferAddr %p\n",Label,Size,Buffer));

  for( i=0 ; i<Size ;i++)
  {
     if ( !(i % 16) )

        ATP_LOG_TST_PRINT((level, "\n" ));

     ATP_LOG_TST_PRINT((level , "0x%02x,",Buffer[i]));

  }

  ATP_LOG_TST_PRINT((level ,"\n\n"));

  return;

}/* END OF ATP_LOG_TST_DisplayBuffer */

#endif /* CRYS_LOG_TST_MAX_LEVEL_ENABLED */


/**********************************************************************************
 * Function Name:
 *  MW_ATP_UTIL_ParseArgs
 *
 * Inputs:
 * int argc - number of arguments in argv
 * char *argv[] - the arguments given to the application
 *  
 * Outputs:
 *  DxError_t - Function error return
 *
 * Description:
 * The following function handles the parsing of the arguemnts by setting the
 * global variables affected by them.
 *
 **********************************************************************************/
DxError_t MW_ATP_UTIL_ParseArgs(int argc, char *argv[])
{
    DxVosFile           TST_main_log_ptr = DX_NULL;
    DxInt32_t           TST_ArgIndex = 0;
    switch (argc) 
    {
      case 1:
        /* no options specified: interactive mode, logging to stdout */
        break;
      default:
        /* iterate through arguments check each one */
        for(TST_ArgIndex=1; TST_ArgIndex<argc; TST_ArgIndex++)
        {
            if (argv[TST_ArgIndex][0] != '-')
                MW_ATP_UTIL_usage(argv[0]);
            //switch on input char - case insensitive
            switch (argv[TST_ArgIndex][1] >= 'a' ? argv[TST_ArgIndex][1] : argv[TST_ArgIndex][1]-'A'+'a')
            {
                case 'b':
                    TST_IsInteractive = 1;
                    break;
                case 'f':
                    TST_log_fname_ptr = argv[TST_ArgIndex+1];
                    if(
                        (DX_VOS_FOpen(&TST_main_log_ptr, TST_log_fname_ptr ,"w") != DX_SUCCESS)
                        ||
                        (TST_main_log_ptr == DX_NULL)
                      )
                    {
                        DX_VOS_Printf("CANT OPEN LOG FILE \n");
                        return TST_FAIL;
                    }
                    DX_VOS_FClose(TST_main_log_ptr);
                    TST_ArgIndex++; //skip the file-name argument
                    break;
                case 'k':
                    TST_UseInternalKG = 1;
                    break;
                default:
                    MW_ATP_UTIL_usage(argv[0]);
            }
        }
    }
    return TST_PASS;
}

/********************************************************************************
 * Function Name:
 *  TST_ATP_GenCheckErrorReturn
 *
 * Inputs:
 *  DxError_t  TST_ErrorRet - The return value of the checked function
 *  char TST_FuncName[TST_FUNC_STRING_LEN] - The checked function name
 *  char     TST_SubTestName[TST_FUNC_STRING_LEN] - The checked sub test name
 *  char     TST_MasterTestName[TST_FUNC_STRING_LEN]- The checked main test name
 *
 * Outputs:
 *  DxUint8_t - Function error return
 *
 * Description:
 * This function Is a utility function to save up some space
 * this function returns the appropriate printing for a checked function
 * If the operation has succeeded of failed the appropriate printing and return value
 *
 ********************************************************************************/
#if 0
DxError_t TST_ATP_GenCheckErrorReturn(DxError_t  TST_ErrorRet,
                                      char         TST_FuncName[TST_FUNC_STRING_LEN],
                                      char         TST_SubTestName[TST_FUNC_STRING_LEN],
                                      char         TST_MasterTestName[TST_FUNC_STRING_LEN])
{
    if (TST_ErrorRet != DX_SUCCESS)
        {
            ATP_LOG_TST_PRINT((MW_ATP_MSG,"\n!!!! TST_Error - Master Test Name -%s\n",TST_MasterTestName));
            ATP_LOG_TST_PRINT((MW_ATP_MSG,"!!!! TST_Error - SubTest Name -%s\n",TST_SubTestName));
            ATP_LOG_TST_PRINT((MW_ATP_MSG,"!!!! TST_Error - %s failed\n",TST_FuncName));
            ATP_LOG_TST_PRINT((MW_ATP_MSG,"!!!! TST_Error - return code 0x%x \n",TST_ErrorRet));
            return TST_FAIL;
        }
    else
        {
            ATP_LOG_TST_PRINT((MW_ATP_MSG,"TST_message - "));
            ATP_LOG_TST_PRINT((MW_ATP_MSG,"%s",TST_FuncName));            
            ATP_LOG_TST_PRINT((MW_ATP_MSG," pass \n"));
            return TST_PASS;
        }
}
#endif

/*****************************************************************************
 * Function Name:
 *  MW_ATP_UTIL_IncLsbUnsignedCounter
 *
 * Inputs:
 *  DxUint32_t *TST_CounterBuffPtr - The buffer containing the counter.
 *  DxUint32_t TST_Val - The value to add
 *  DxUint8_t  TST_ConterSize - the counter size in 32bit words
 *
 * Outputs:
 *   None
 *
 * Description:
 * 		This function adds a value to a large counter presented in a buffer.
 *      The LSB of the counter is stored in the first cell in the array.
 *
 ******************************************************************************/                              
 void MW_ATP_UTIL_IncLsbUnsignedCounter(DxUint32_t *TST_CounterBuffPtr,
                                        DxUint32_t TST_Val,
                                        DxUint8_t  TST_CounterSize )
 {
	/* LOCAL DECLERATIONS */
  	/**********************/
 	/* a value for storing the current counter word value */
	DxUint32_t curretCounterWordVal = 0;    
    DxInt32_t i = 0;
   
   	/* FUNCTION LOGIC */
   	/*****************/
   	curretCounterWordVal = TST_CounterBuffPtr[0];
   
   	/* adding the value to the LSW */   
   	TST_CounterBuffPtr[0] += TST_Val;
        
   	/* adding the carry to the higher words if there is overflow on the word 
       then handle the upper words */
   	if( curretCounterWordVal > TST_CounterBuffPtr[0] )
   	{  
     	/* adding the carry to the counter loop */
     	for( i = 1 ; i < TST_CounterSize ; i++ )
     	{
        	/* set the current word value */
        	curretCounterWordVal = TST_CounterBuffPtr[i];
      
        	/* adding the carry to the current word */
        	TST_CounterBuffPtr[i]++;
            
        	/* if there is no overflow on the current word after adding the value 
           	   exit the loop */
        	if( curretCounterWordVal < TST_CounterBuffPtr[i] )       
          		break;        
     	}/* end of adding the carry loop */     
   	}/* end of setting the carrier on the upper words */  
   	return;
 }

/************************ Private Functions *************************/

static void MW_ATP_UTIL_usage(char *pname)
{
  DX_VOS_Printf("Usage: %s [-b] [-f logfile] [-k]\n", pname);
  exit (-1);
}

/*****************************************************************************
* Function Name:                                                           
* MW_ATP_UTIL_CheckExpectedErrorReturn        
* 
* Inputs:
*  DxUint32_t       ErrorRet                                 The return value of the checked function
*  DxUint32_t       ExpectedError                            The expected return value of the checked function
*  char             FuncName[TST_FUNC_STRING_LEN]            The checked function name 
*  char             SubTestName[TST_FUNC_STRING_LEN]         The checked sub test name
*  char             MasterTestName[TST_FUNC_STRING_LEN]      The checked main test name
*
* Outputs:
*  DxError_t - Function error return                                     
*
* Description:                                                                 
* The function returns the appropriate printing for a checked function
* comparing the returned error result vs the expected error result. 
******************************************************************************/
DxError_t MW_ATP_UTIL_CheckExpectedErrorReturn(DxError_t   ErrorRet, 
                                               DxError_t   ExpectedError, 
                                               char        FuncName[TST_FUNC_STRING_LEN],
                                               char        SubTestName[TST_FUNC_STRING_LEN],
                                               char        MasterTestName[TST_FUNC_STRING_LEN])
{
  if (ErrorRet != ExpectedError)
  {

    ATP_LOG_TST_PRINT((MW_ATP_MSG,"\n!!!! TST_Error - Master Test Name -%s\n",MasterTestName));
    ATP_LOG_TST_PRINT((MW_ATP_MSG,"!!!! TST_Error - SubTest Name -%s\n",SubTestName));           
    ATP_LOG_TST_PRINT((MW_ATP_MSG,"!!!! TST_Error - %s failed\n",FuncName));
    ATP_LOG_TST_PRINT((MW_ATP_MSG,"!!!! TST_Error - Wrong Error returned!\n"));
    ATP_LOG_TST_PRINT((MW_ATP_MSG,"!!!! TST_Error - Error returned  --- 0x%x \n" ,ErrorRet ));    
    ATP_LOG_TST_PRINT((MW_ATP_MSG,"!!!! TST_Error - Instead of Error --- 0x%x \n" ,ExpectedError ));           


    return TST_FAIL;      
  }

  else
  {
    ATP_LOG_TST_PRINT((MW_ATP_MSG,"TST_massage - "));
    ATP_LOG_TST_PRINT((MW_ATP_MSG,"%s",FuncName));
    ATP_LOG_TST_PRINT((MW_ATP_MSG," Error returned correctly \n"));                          
    return TST_PASS;        
  }   

}
